/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import icyllis.modernui.text.GetChars;
import icyllis.modernui.text.Spanned;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;

public final class TextUtils {
    private static final Object sLock = new Object();
    private static char[] sTemp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static char[] obtain(int len) {
        char[] buf;
        Object object = sLock;
        synchronized (object) {
            buf = sTemp;
            sTemp = null;
        }
        if (buf == null || buf.length < len) {
            buf = new char[len];
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(@Nonnull char[] temp) {
        if (temp.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = temp;
        }
    }

    public static void getChars(@Nonnull CharSequence s2, int start, int end, char[] dest, int destoff) {
        Class<?> c = s2.getClass();
        if (c == String.class) {
            ((String)s2).getChars(start, end, dest, destoff);
        } else if (c == StringBuffer.class) {
            ((StringBuffer)s2).getChars(start, end, dest, destoff);
        } else if (c == StringBuilder.class) {
            ((StringBuilder)s2).getChars(start, end, dest, destoff);
        } else if (s2 instanceof GetChars) {
            ((GetChars)s2).getChars(start, end, dest, destoff);
        } else {
            for (int i = start; i < end; ++i) {
                dest[destoff++] = s2.charAt(i);
            }
        }
    }

    public static <T> T[] removeEmptySpans(@Nonnull T[] spans, Spanned spanned, Class<T> clazz) {
        Object[] copy = null;
        int count = 0;
        for (int i = 0; i < spans.length; ++i) {
            int end;
            T span = spans[i];
            int start = spanned.getSpanStart(span);
            if (start == (end = spanned.getSpanEnd(span))) {
                if (copy != null) continue;
                copy = (Object[])Array.newInstance(clazz, spans.length - 1);
                System.arraycopy(spans, 0, copy, 0, i);
                count = i;
                continue;
            }
            if (copy == null) continue;
            copy[count] = span;
            ++count;
        }
        if (copy == null) {
            return spans;
        }
        Object[] result = (Object[])Array.newInstance(clazz, count);
        System.arraycopy(copy, 0, result, 0, count);
        return result;
    }

    public static int indexOf(CharSequence s2, char ch) {
        return TextUtils.indexOf(s2, ch, 0);
    }

    public static int indexOf(CharSequence s2, char ch, int start) {
        if (s2 instanceof String) {
            return ((String)s2).indexOf(ch, start);
        }
        return TextUtils.indexOf(s2, ch, start, s2.length());
    }

    public static int indexOf(@Nonnull CharSequence s2, char ch, int start, int end) {
        Class<?> c = s2.getClass();
        if (s2 instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segend = start + 500;
                if (segend > end) {
                    segend = end;
                }
                TextUtils.getChars(s2, start, segend, temp, 0);
                int count = segend - start;
                for (int i = 0; i < count; ++i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + start;
                }
                start = segend;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (s2.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }
}

